/***************************************************************/
//
//
//		DirectX	[title_run_player.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 05/30
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

Update : 2016/06/06
			_obt@[̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include "title_run_player.h"
#include "formula.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define PLAYER_TEXTURENAME "data/TEXTURE/runningman000.png"

#define PLAYER_POS_X ( SCREEN_WIDTH /2 )			//|S̕\ʒuX
#define PLAYER_POS_Y ( SCREEN_HEIGHT /2 +50 )			//|S̕\ʒuY
#define PLAYER_WIDTH (440)							//|S̕
#define PLAYER_HEIGHT (400)							//|S̍

#define PLAYER_RADIUS_X ( 50/2 )					//wiIuWFNg̔aX
#define PLAYER_RADIUS_Y ( 100/2 )					//wiIuWFNg̔aY

#define PLAYER_TEXTURE_U_SIZE (0.125f)

/*---------------------------------------------------------------
	\
---------------------------------------------------------------*/

// player\
typedef struct{

	float playerTexU;
	float playerTexV;

	float playerTexMoveX;
	float playerTexMoveY;

	float playerTexX;
	float playerTexY;
	float playerTexX2;
	float playerTexY2;

	float playerTexX3;
	float playerTexY3;
	float playerTexX4;
	float playerTexY4;

	VECTOR_2D vec;

	unsigned int playerFrame;
	//unsigned float playerFrame;

}PLAYER;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexTitleRunPlayer(LPDIRECT3DDEVICE9 pDevice);
													//_̍쐬
/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureTitleRunPlayer = nullptr;	//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferTitleRunPlayer = nullptr;
													//_obt@C^[tF[Xւ̃|C^
PLAYER g_titleRunPlayer;								//郉jO}̍\

int titleRunArc = 0;									//ƃjO}̉]px

// TP̏
void InitTitleRunPlayer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;		//foCX󂯎p֐


	// foCX̎󂯎
	pDevice = GetDevice( );

	// VERTEX_2D̐ݒ
	MakeVertexTitleRunPlayer(pDevice);

	// eNX`̓ǂݍ
	if(FAILED(D3DXCreateTextureFromFile(pDevice,PLAYER_TEXTURENAME,&g_pTextureTitleRunPlayer)))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}


}
// TP̏I
void UninitTitleRunPlayer( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureTitleRunPlayer)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferTitleRunPlayer)

}
// TP̍XV
void UpdateTitleRunPlayer( void ){

	VERTEX_2D *pVtx;									//zAhX

	// UVlvZ
	g_titleRunPlayer.playerTexU = (float)( ( g_titleRunPlayer.playerFrame ) % 8 ) * PLAYER_TEXTURE_U_SIZE;
	//playerTexU = ( ( playerFrame ) % 5 ) * PLAYER_TEXTURE_U_SIZE;
	
	// pxXV
	titleRunArc+=30;
	
	// |S̉]
	if( g_titleRunPlayer.playerFrame >= 24 ){

		g_titleRunPlayer.playerTexX = (-PLAYER_RADIUS_X) * cos( RADIAN(titleRunArc) ) - (-PLAYER_RADIUS_Y) * sin( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexY = (-PLAYER_RADIUS_X) * sin( RADIAN(titleRunArc) ) + (-PLAYER_RADIUS_Y) * cos( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexX2 = PLAYER_RADIUS_X * cos( RADIAN(titleRunArc) ) - (-PLAYER_RADIUS_Y) * sin( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexY2 = PLAYER_RADIUS_X * sin( RADIAN(titleRunArc) ) + (-PLAYER_RADIUS_Y) * cos( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexX3 = (-PLAYER_RADIUS_X) * cos( RADIAN(titleRunArc) ) - (PLAYER_RADIUS_Y) * sin( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexY3 = (-PLAYER_RADIUS_X) * sin( RADIAN(titleRunArc) ) + (PLAYER_RADIUS_Y) * cos( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexX4 = (PLAYER_RADIUS_X) * cos( RADIAN(titleRunArc) ) - (PLAYER_RADIUS_Y) * sin( RADIAN(titleRunArc) );
		g_titleRunPlayer.playerTexY4 = (PLAYER_RADIUS_X) * sin( RADIAN(titleRunArc) ) + (PLAYER_RADIUS_Y) * cos( RADIAN(titleRunArc) );
	
	}

	// obt@bNzAhX擾
	g_pVtxBufferTitleRunPlayer -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN


	// UVAj[V
	pVtx[0].tex=D3DXVECTOR2( g_titleRunPlayer.playerTexU, g_titleRunPlayer.playerTexV );
	pVtx[1].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_titleRunPlayer.playerTexU, g_titleRunPlayer.playerTexV );
	pVtx[2].tex=D3DXVECTOR2( g_titleRunPlayer.playerTexU, 1.0f+g_titleRunPlayer.playerTexV );
	pVtx[3].tex=D3DXVECTOR2( PLAYER_TEXTURE_U_SIZE+g_titleRunPlayer.playerTexU, 1.0f+g_titleRunPlayer.playerTexV );

	// _XV
	
	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X+(-PLAYER_RADIUS_X)+g_titleRunPlayer.playerTexX, PLAYER_POS_Y+(-PLAYER_RADIUS_Y)+g_titleRunPlayer.playerTexY, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_POS_X+PLAYER_RADIUS_X+g_titleRunPlayer.playerTexX2, PLAYER_POS_Y+(-PLAYER_RADIUS_Y)+g_titleRunPlayer.playerTexY2, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X+(-PLAYER_RADIUS_X)+g_titleRunPlayer.playerTexX3, PLAYER_POS_Y+PLAYER_RADIUS_Y+g_titleRunPlayer.playerTexY3, 0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_POS_X+PLAYER_RADIUS_X+g_titleRunPlayer.playerTexX4, PLAYER_POS_Y+PLAYER_RADIUS_Y+g_titleRunPlayer.playerTexY4, 0.0f);
	
	/*
	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X+g_titleRunPlayer.playerTexX, PLAYER_POS_Y+g_titleRunPlayer.playerTexY, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_POS_X+g_titleRunPlayer.playerTexX2, PLAYER_POS_Y+g_titleRunPlayer.playerTexY2, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X+g_titleRunPlayer.playerTexX3, PLAYER_POS_Y+g_titleRunPlayer.playerTexY3, 0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_POS_X+g_titleRunPlayer.playerTexX4, PLAYER_POS_Y+g_titleRunPlayer.playerTexY4, 0.0f);
	*/

	//ColorPlayer ( pVtx );

	// obt@̃AbN
	g_pVtxBufferTitleRunPlayer->Unlock();

	g_titleRunPlayer.playerFrame++;

	FRAME_RESET( g_titleRunPlayer.playerFrame , 48 )

}
// TP̕`
void DrawTitleRunPlayer( void )
{

	LPDIRECT3DDEVICE9 pDevice=nullptr;					//foCX󂯎p֐


	// foCX̎󂯎菈
	pDevice=GetDevice( );

	// Xg[
	pDevice->SetStreamSource(0,							//MS
	g_pVtxBufferTitleRunPlayer,							//ǂ̒_obt@\ƌԂ...
	0,													//f[^̃ItZbg
	sizeof(VERTEX_2D));									//XgChl(oCg)
		
	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	pDevice->SetTexture(0,g_pTextureTitleRunPlayer);		//_UVf[^Zbg
	
	// |S̕`
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_PLAYER);


}
// TP̍쐬
HRESULT MakeVertexTitleRunPlayer( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferTitleRunPlayer,					//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferTitleRunPlayer -> Lock(0,0,(void**)&pVtx,0);	//GPUVRAMւ̑bN

	// _W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_POS_Y, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_POS_Y, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( PLAYER_POS_X, PLAYER_HEIGHT,0.0f);
	pVtx[3].pos=D3DXVECTOR3( PLAYER_WIDTH, PLAYER_HEIGHT,0.0f);

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );

	// obt@̃AbN
	g_pVtxBufferTitleRunPlayer->Unlock();

	return S_OK;

}

